/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.client.screen;

import com.direwolf20.buildinggadgets.client.screen.GuiMod;
import com.direwolf20.buildinggadgets.client.screen.components.GuiSliderInt;
import com.direwolf20.buildinggadgets.common.config.Config;
import com.direwolf20.buildinggadgets.common.items.GadgetDestruction;
import com.direwolf20.buildinggadgets.common.network.PacketHandler;
import com.direwolf20.buildinggadgets.common.network.packets.PacketDestructionGUI;
import com.direwolf20.buildinggadgets.common.util.lang.GuiTranslation;
import com.direwolf20.buildinggadgets.common.util.lang.MessageTranslation;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;

public class DestructionGUI
extends Screen {
    private final Set<GuiDestructionSlider> sliders = new HashSet<GuiDestructionSlider>();
    private GuiDestructionSlider left;
    private GuiDestructionSlider right;
    private GuiDestructionSlider up;
    private GuiDestructionSlider down;
    private GuiDestructionSlider depth;
    private Button confirm;
    private String sizeString = "";
    private boolean isValidSize = true;
    private final ItemStack destructionTool;

    public DestructionGUI(ItemStack tool) {
        super((Component)new TextComponent("Destruction Gui?!?"));
        this.destructionTool = tool;
    }

    public void m_7856_() {
        super.m_7856_();
        int x = this.f_96543_ / 2;
        int y = this.f_96544_ / 2;
        this.confirm = new Button(x - 30 + 32, y + 65, 60, 20, (Component)new TranslatableComponent(GuiMod.getLangKeySingle("confirm")), b -> {
            if (Minecraft.m_91087_().f_91074_ == null) {
                return;
            }
            if (this.isWithinBounds()) {
                PacketHandler.sendToServer(new PacketDestructionGUI(this.left.getValueInt(), this.right.getValueInt(), this.up.getValueInt(), this.down.getValueInt(), this.depth.getValueInt()));
                this.m_7379_();
            } else {
                Minecraft.m_91087_().f_91074_.m_5661_((Component)MessageTranslation.DESTRCUT_TOO_LARGE.componentTranslation(Config.GADGETS.GADGET_DESTRUCTION.destroySize.get()), true);
            }
        });
        this.m_142416_((GuiEventListener)this.confirm);
        this.m_142416_((GuiEventListener)new Button(x - 30 - 32, y + 65, 60, 20, (Component)new TranslatableComponent(GuiMod.getLangKeySingle("cancel")), b -> this.m_7379_()));
        this.sliders.clear();
        this.depth = new GuiDestructionSlider(x - 35, y - 7, GuiTranslation.SINGLE_DEPTH.format(new Object[0]) + ":", GadgetDestruction.getToolValue(this.destructionTool, "depth"));
        this.sliders.add(this.depth);
        this.right = new GuiDestructionSlider(x + 75, y - 7, GuiTranslation.SINGLE_RIGHT.format(new Object[0]) + ":", GadgetDestruction.getToolValue(this.destructionTool, "right"));
        this.sliders.add(this.right);
        this.left = new GuiDestructionSlider(x - 140 - 5, y - 7, GuiTranslation.SINGLE_LEFT.format(new Object[0]) + ":", GadgetDestruction.getToolValue(this.destructionTool, "left"));
        this.sliders.add(this.left);
        this.up = new GuiDestructionSlider(x - 35, y - 35, GuiTranslation.SINGLE_UP.format(new Object[0]) + ":", GadgetDestruction.getToolValue(this.destructionTool, "up"));
        this.sliders.add(this.up);
        this.down = new GuiDestructionSlider(x - 35, y + 20, GuiTranslation.SINGLE_DOWN.format(new Object[0]) + ":", GadgetDestruction.getToolValue(this.destructionTool, "down"));
        this.sliders.add(this.down);
        this.updateSizeString();
        this.updateIsValid();
        this.sliders.forEach(gui -> gui.getComponents().forEach(x$0 -> {
            Button cfr_ignored_0 = (Button)this.m_142416_((GuiEventListener)x$0);
        }));
    }

    private boolean isWithinBounds() {
        int x = 1 + this.left.getValueInt() + this.right.getValueInt();
        int y = 1 + this.up.getValueInt() + this.down.getValueInt();
        int z = this.depth.getValueInt();
        int dim = (Integer)Config.GADGETS.GADGET_DESTRUCTION.destroySize.get();
        return x <= dim + 1 && y <= dim + 1 && z <= dim;
    }

    private String getSizeString() {
        int x = 1 + this.left.getValueInt() + this.right.getValueInt();
        int y = 1 + this.up.getValueInt() + this.down.getValueInt();
        int z = this.depth.getValueInt();
        return String.format("%d x %d x %d", x, y, z);
    }

    private void updateIsValid() {
        this.isValidSize = this.isWithinBounds();
        if (!this.isValidSize && this.confirm.f_93623_) {
            this.confirm.setFGColor(0xFF2000);
            this.confirm.f_93623_ = false;
        }
        if (this.isValidSize && !this.confirm.f_93623_) {
            this.confirm.clearFGColor();
            this.confirm.f_93623_ = true;
        }
    }

    private void updateSizeString() {
        this.sizeString = this.getSizeString();
    }

    public void m_6305_(@Nonnull PoseStack matrices, int mouseX, int mouseY, float partialTicks) {
        super.m_6305_(matrices, mouseX, mouseY, partialTicks);
        DestructionGUI.m_93208_((PoseStack)matrices, (Font)this.f_96547_, (String)this.sizeString, (int)(this.f_96543_ / 2), (int)(this.f_96544_ / 2 + 40), (int)(this.isValidSize ? 65280 : 0xFF2000));
        if (!this.isValidSize) {
            DestructionGUI.m_93208_((PoseStack)matrices, (Font)this.f_96547_, (String)MessageTranslation.DESTRCUT_TOO_LARGE.format(Config.GADGETS.GADGET_DESTRUCTION.destroySize.get()), (int)(this.f_96543_ / 2), (int)(this.f_96544_ / 2 + 50), (int)0xFF2000);
        }
    }

    public boolean m_6348_(double mouseX, double mouseY, int mouseButton) {
        for (GuiDestructionSlider slider : this.sliders) {
            slider.m_7691_(mouseX, mouseY);
        }
        return true;
    }

    public boolean m_7043_() {
        return false;
    }

    private class GuiDestructionSlider
    extends GuiSliderInt {
        public static final int width = 70;
        public static final int height = 14;
        private static final int min = 0;
        private static final int max = 16;

        GuiDestructionSlider(int x, int y, String prefix, int current) {
            super(x, y, 70, 14, (Component)new TextComponent(String.format("%s ", prefix)), (Component)new TextComponent(""), 0.0, 16.0, current, false, true, Color.DARK_GRAY, null, (slider, amount) -> {
                slider.setValue(Mth.m_14045_((int)(slider.getValueInt() + amount), (int)0, (int)16));
                slider.updateSlider();
            });
        }

        @Override
        public void updateSlider() {
            super.updateSlider();
            DestructionGUI.this.updateSizeString();
            DestructionGUI.this.updateIsValid();
        }
    }
}

